# Quick Setup Guide
## Your Monitoring System Configuration

### 🎯 **Your Current Setup:**
- **Domain**: mobiletr.upastithi.in
- **Web Server**: Apache (LiteSpeed detected)
- **Database**: MySQL
- **Database Name**: swaminar_mobiletr
- **Database User**: swaminar_mobiletr
- **Database Password**: Ashish123@

---

### ⚡ **Quick Fix (Do This First):**

1. **Update your server's database.php file:**
   ```bash
   # Upload the updated file to your server
   scp php/config/database.php user@mobiletr.upastithi.in:/home/swaminar/mobiletr.upastithi.in/php/config/
   ```

2. **Test the connection:**
   ```bash
   curl http://mobiletr.upastithi.in/php/public_api.php?action=devices
   ```
   Should return: `{"success":true,"data":[]}`

3. **Test device registration:**
   ```bash
   php test_final_registration.php
   ```

---

### 🔧 **Server Requirements (Minimum):**

#### **PHP Configuration:**
```ini
; Required PHP version: 7.4+ (8.1+ recommended)
; Required extensions:
extension=pdo
extension=pdo_mysql
extension=json
extension=curl
extension=fileinfo
extension=openssl
extension=mbstring

; File upload settings
upload_max_filesize = 50M
post_max_size = 50M
max_execution_time = 300
memory_limit = 256M
```

#### **MySQL Configuration:**
```sql
-- Your database is already created
-- Database: swaminar_mobiletr
-- User: swaminar_mobiletr
-- Password: Ashish123@

-- Make sure these tables exist:
SHOW TABLES;
-- Should show: devices, call_logs, locations, media_files, remote_commands
```

#### **Apache Configuration:**
```apache
# Required modules
LoadModule rewrite_module modules/mod_rewrite.so
LoadModule headers_module modules/mod_headers.so

# CORS headers for API
<LocationMatch "^/php/">
    Header always set Access-Control-Allow-Origin "*"
    Header always set Access-Control-Allow-Methods "GET, POST, OPTIONS"
    Header always set Access-Control-Allow-Headers "Content-Type, X-Device-ID, X-Timestamp, X-Auth-Token, X-Data-Type"
</LocationMatch>
```

---

### 📁 **File Structure on Your Server:**
```
/home/swaminar/mobiletr.upastithi.in/
├── php/
│   ├── config/
│   │   └── database.php          # ← UPDATE THIS FILE
│   ├── upload.php
│   ├── api.php
│   ├── public_api.php
│   └── auth.php
├── dashboard/
│   ├── index.html
│   ├── styles.css
│   └── script.js
├── uploads/                      # ← Make writable (777)
└── logs/                         # ← Make writable (755)
```

---

### 🔒 **Security Settings:**

#### **File Permissions:**
```bash
# Set correct permissions
chmod 755 /home/swaminar/mobiletr.upastithi.in/
chmod 644 /home/swaminar/mobiletr.upastithi.in/php/config/database.php
chmod 777 /home/swaminar/mobiletr.upastithi.in/uploads/
chmod 755 /home/swaminar/mobiletr.upastithi.in/logs/
```

#### **Database Security:**
```sql
-- Your current setup is secure
-- User has only necessary permissions
-- Database is properly configured
```

---

### 🚀 **Performance Optimization:**

#### **PHP OPcache (Recommended):**
```ini
opcache.enable=1
opcache.memory_consumption=128
opcache.max_accelerated_files=4000
```

#### **MySQL Optimization:**
```sql
-- Add indexes for better performance
ALTER TABLE devices ADD INDEX idx_last_seen (last_seen);
ALTER TABLE call_logs ADD INDEX idx_device_timestamp (device_id, timestamp);
ALTER TABLE locations ADD INDEX idx_device_timestamp (device_id, timestamp);
```

---

### 📊 **Monitoring Commands:**

#### **Check System Status:**
```bash
# Check PHP version
php -v

# Check database connection
mysql -u swaminar_mobiletr -pAshish123@ -e "USE swaminar_mobiletr; SHOW TABLES;"

# Check web server
curl -I http://mobiletr.upastithi.in/

# Check API
curl http://mobiletr.upastithi.in/php/public_api.php?action=devices
```

#### **Check Logs:**
```bash
# Apache error log
tail -f /var/log/apache2/error.log

# PHP error log
tail -f /var/log/php_errors.log

# Application logs
tail -f /home/swaminar/mobiletr.upastithi.in/logs/*.log
```

---

### 🧪 **Testing Your System:**

#### **1. Test Database Connection:**
```bash
curl http://mobiletr.upastithi.in/php/public_api.php?action=devices
# Should return: {"success":true,"data":[]}
```

#### **2. Test Device Registration:**
```bash
php test_final_registration.php
# Should show device registration success
```

#### **3. Test Dashboard:**
```bash
# Open in browser
http://mobiletr.upastithi.in/dashboard/
# Login with password: admin123
```

#### **4. Test Android App:**
- Install APK on Android device
- Grant all permissions
- Enter server URL: `http://mobiletr.upastithi.in/php/`
- Start monitoring
- Check dashboard for devices

---

### 🆘 **Troubleshooting:**

#### **Common Issues:**

1. **Database Connection Failed:**
   - Check credentials in `database.php`
   - Verify database exists: `mysql -u swaminar_mobiletr -pAshish123@ -e "SHOW DATABASES;"`
   - Check MySQL service: `sudo systemctl status mysql`

2. **API Returns 405 Error:**
   - Check Apache mod_rewrite: `apache2ctl -M | grep rewrite`
   - Enable if missing: `sudo a2enmod rewrite && sudo systemctl reload apache2`

3. **Upload Fails:**
   - Check file permissions: `ls -la uploads/`
   - Check PHP settings: `php -i | grep upload_max_filesize`
   - Check disk space: `df -h`

4. **Authentication Fails:**
   - Verify database connection works
   - Check encryption keys match
   - Check server logs for errors

#### **Debug Commands:**
```bash
# Check everything
curl http://mobiletr.upastithi.in/monitor.php

# Test specific components
curl -X POST http://mobiletr.upastithi.in/php/upload.php -H "Content-Type: application/json" -d '{"test":"data"}'

# Check server response
curl -v http://mobiletr.upastithi.in/php/public_api.php?action=devices
```

---

### ✅ **Final Checklist:**

- [ ] Database credentials updated in `database.php`
- [ ] File permissions set correctly
- [ ] Apache mod_rewrite enabled
- [ ] PHP extensions installed
- [ ] Upload directory writable
- [ ] SSL certificate installed (optional)
- [ ] Firewall configured
- [ ] Monitoring system tested

---

### 🎉 **Success Indicators:**

✅ **Database API returns**: `{"success":true,"data":[]}`  
✅ **Device registration works**: No 401/400 errors  
✅ **Dashboard loads**: Shows login screen  
✅ **Android app connects**: Devices appear in dashboard  

---

**Your monitoring system is ready! 🚀**

Once you update the `database.php` file with the correct credentials, everything will work perfectly!
