# Android Monitoring & Remote Control System

A comprehensive personal Android monitoring and remote control system with a web dashboard designed for shared hosting environments.

## ⚠️ IMPORTANT LEGAL NOTICE

**This software is for educational and authorized monitoring purposes only. Users must comply with all applicable laws and regulations regarding privacy, surveillance, and device monitoring. The developers are not responsible for any misuse of this software.**

## Features

### Android App (Kotlin)
- **Foreground Service**: Continuous background monitoring
- **Call & Contact Monitoring**: 
  - Read incoming, outgoing, and missed calls
  - Track call duration, timestamps, and contact information
  - Monitor contact changes and additions
  - GPS location tracking during calls
- **GPS Tracking**: 
  - Live location updates
  - Historical location data
  - Geocoding for address information
- **Media Access**: 
  - Access to images, videos, and audio files
  - Automatic upload of new media
  - File type filtering and organization
- **Remote Control**: 
  - Device vibration control
  - Ring device remotely
  - Take photos (front/back camera)
  - Delete files remotely
  - Audio recording control
  - Screen capture capabilities
- **File Explorer**: Browse and manage device files
- **Secure Communication**: Encrypted data transmission

### Web Dashboard (PHP/HTML/JS)
- **Real-time Monitoring**: Live updates of device status and data
- **Call Logs**: Comprehensive call history with location data
- **Location Tracking**: Interactive maps with GPS coordinates
- **Media Gallery**: View and download uploaded media files
- **Remote Control Panel**: Send commands to connected devices
- **Device Management**: Monitor multiple devices simultaneously
- **Responsive Design**: Works on desktop and mobile browsers

## System Requirements

### Android App
- Android 7.0 (API level 24) or higher
- Required permissions:
  - Camera
  - Microphone
  - Location (Fine and Coarse)
  - Storage (Read/Write)
  - Call Log
  - Contacts
  - Phone State
  - Vibration
  - Internet Access

### Web Server
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache/Nginx web server
- SSL certificate (recommended)
- Shared hosting compatible

## Installation

### 1. Database Setup

1. Create a MySQL database:
```sql
CREATE DATABASE monitoring_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

2. Import the database schema:
```bash
mysql -u username -p monitoring_db < database/schema.sql
```

3. Create a database user:
```sql
CREATE USER 'monitoring_user'@'localhost' IDENTIFIED BY 'secure_password';
GRANT SELECT, INSERT, UPDATE, DELETE ON monitoring_db.* TO 'monitoring_user'@'localhost';
FLUSH PRIVILEGES;
```

### 2. Web Server Setup

1. Upload PHP files to your web server:
```
/your-domain.com/
├── php/
│   ├── config/
│   │   └── database.php
│   ├── upload.php
│   ├── get_commands.php
│   ├── send_command.php
│   ├── auth.php
│   └── api.php
├── dashboard/
│   ├── index.html
│   ├── styles.css
│   └── script.js
└── uploads/
    └── (device uploads will be stored here)
```

2. Configure database settings in `php/config/database.php`:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'monitoring_db');
define('DB_USER', 'monitoring_user');
define('DB_PASS', 'your_secure_password');
define('API_KEY', 'your_secret_api_key');
define('DASHBOARD_PASSWORD', 'your_dashboard_password');
```

3. Set proper file permissions:
```bash
chmod 755 uploads/
chmod 644 php/config/database.php
```

### 3. Android App Setup

1. Open the project in Android Studio
2. Update the server URL in `MainActivity.kt`:
```kotlin
serverUrlEditText.setText("https://your-domain.com/php/")
```

3. Build and install the APK on target devices
4. Grant all required permissions when prompted
5. Enter the server URL and start monitoring

## Configuration

### Security Settings

1. **Change default passwords** in `php/config/database.php`:
   - `DASHBOARD_PASSWORD`: Dashboard login password
   - `API_KEY`: Device authentication key
   - `ENCRYPTION_KEY`: Data encryption key

2. **Enable HTTPS** for secure communication
3. **Configure firewall** to restrict access
4. **Regular database cleanup** using the provided stored procedure

### Android App Configuration

1. **Server URL**: Update to your web server address
2. **Polling Interval**: Adjust command polling frequency (default: 30 seconds)
3. **Upload Intervals**: Configure data upload frequencies
4. **File Size Limits**: Set maximum file sizes for uploads

## Usage

### Starting the Android App

1. Launch the app on the target device
2. Enter the server URL (e.g., `https://your-domain.com/php/`)
3. Grant all required permissions
4. Tap "Start Monitoring"
5. The app will run as a foreground service

### Accessing the Web Dashboard

1. Navigate to `https://your-domain.com/dashboard/`
2. Enter the dashboard password
3. View connected devices and their data
4. Use remote control features as needed

### Remote Commands

Available commands:
- `vibrate`: Vibrate the device
- `ring`: Ring the device at maximum volume
- `take_photo`: Take a photo (front/back camera)
- `record_audio`: Start audio recording
- `stop_recording`: Stop audio recording
- `delete_file`: Delete specified file
- `get_files`: Upload file list
- `set_volume`: Set device volume
- `play_sound`: Play specified sound file

## API Endpoints

### Device Endpoints
- `POST /php/upload.php`: Upload device data
- `GET /php/get_commands.php`: Poll for commands
- `POST /php/send_command.php`: Send remote commands

### Dashboard Endpoints
- `POST /php/auth.php`: Dashboard authentication
- `GET /php/api.php`: Retrieve monitoring data

## Database Schema

The system uses the following main tables:
- `devices`: Connected device information
- `call_logs`: Call history and details
- `locations`: GPS location data
- `media_files`: Uploaded media files
- `remote_commands`: Command queue and history
- `contacts`: Contact change tracking
- `system_logs`: System debugging information

## Security Considerations

1. **Data Encryption**: All sensitive data is encrypted before transmission
2. **Authentication**: Device and dashboard authentication required
3. **Access Control**: Database user with limited privileges
4. **HTTPS**: Encrypted communication (recommended)
5. **File Validation**: Uploaded files are validated and sanitized
6. **Session Management**: Dashboard sessions with timeout

## Troubleshooting

### Common Issues

1. **App not connecting**: Check server URL and network connectivity
2. **Permissions denied**: Ensure all required permissions are granted
3. **Upload failures**: Check file permissions and server configuration
4. **Dashboard login issues**: Verify password configuration
5. **Database connection errors**: Check database credentials and connectivity

### Debug Mode

Enable debug logging by modifying the Android app's log level and checking server error logs.

### Performance Optimization

1. **Database indexing**: Ensure proper indexes are created
2. **File cleanup**: Regularly clean old uploads and logs
3. **Network optimization**: Adjust polling intervals based on usage
4. **Storage management**: Monitor disk usage and implement cleanup routines

## Maintenance

### Regular Tasks

1. **Database cleanup**: Run cleanup procedures to remove old data
2. **Log rotation**: Manage system logs to prevent disk space issues
3. **Security updates**: Keep PHP and MySQL updated
4. **Backup**: Regular database and file backups

### Monitoring

- Check device connectivity status
- Monitor upload success rates
- Review system logs for errors
- Track storage usage

## Legal and Ethical Considerations

- **Authorization**: Only monitor devices you own or have explicit permission to monitor
- **Privacy Laws**: Comply with local privacy and surveillance laws
- **Data Protection**: Implement appropriate data protection measures
- **Consent**: Ensure proper consent for any monitoring activities
- **Retention**: Implement appropriate data retention policies

## Support

For technical support and questions:
1. Check the troubleshooting section
2. Review system logs for error messages
3. Verify configuration settings
4. Test network connectivity and permissions

## Version History

- **v1.0**: Initial release with core monitoring features
- Features: Call logs, location tracking, media access, remote control
- Compatibility: Android 7.0+, PHP 7.4+, MySQL 5.7+

## License

This software is provided for educational purposes. Users are responsible for compliance with applicable laws and regulations.

---

**Remember**: This system should only be used for legitimate monitoring purposes with proper authorization and in compliance with applicable laws.
