<?php
// Check current database state
require_once 'php/config/database.php';

echo "📊 Database State Check\n";
echo "======================\n\n";

// Test database connection
$pdo = getDatabaseConnection();
if (!$pdo) {
    echo "❌ Cannot connect to database!\n";
    exit(1);
}

echo "✅ Database connection successful!\n\n";

// Check devices table
echo "📱 Devices in Database:\n";
echo "----------------------\n";
try {
    $stmt = $pdo->query("SELECT * FROM devices ORDER BY last_seen DESC");
    $devices = $stmt->fetchAll();
    
    if (empty($devices)) {
        echo "No devices found in database.\n";
    } else {
        foreach ($devices as $device) {
            echo "Device ID: " . $device['device_id'] . "\n";
            echo "Name: " . $device['device_name'] . "\n";
            echo "Last Seen: " . $device['last_seen'] . "\n";
            echo "Created: " . $device['created_at'] . "\n";
            echo "---\n";
        }
    }
} catch (Exception $e) {
    echo "❌ Error querying devices: " . $e->getMessage() . "\n";
}

// Check locations table
echo "\n📍 Recent Locations:\n";
echo "-------------------\n";
try {
    $stmt = $pdo->query("SELECT * FROM locations ORDER BY timestamp DESC LIMIT 5");
    $locations = $stmt->fetchAll();
    
    if (empty($locations)) {
        echo "No location data found.\n";
    } else {
        foreach ($locations as $location) {
            echo "Device: " . $location['device_id'] . "\n";
            echo "Location: " . $location['latitude'] . ", " . $location['longitude'] . "\n";
            echo "Address: " . $location['address'] . "\n";
            echo "Time: " . date('Y-m-d H:i:s', $location['timestamp'] / 1000) . "\n";
            echo "---\n";
        }
    }
} catch (Exception $e) {
    echo "❌ Error querying locations: " . $e->getMessage() . "\n";
}

// Check media files table
echo "\n📁 Recent Media Files:\n";
echo "---------------------\n";
try {
    $stmt = $pdo->query("SELECT * FROM media_files ORDER BY uploaded_at DESC LIMIT 5");
    $media = $stmt->fetchAll();
    
    if (empty($media)) {
        echo "No media files found.\n";
    } else {
        foreach ($media as $file) {
            echo "Device: " . $file['device_id'] . "\n";
            echo "File: " . $file['file_name'] . "\n";
            echo "Type: " . $file['file_type'] . "\n";
            echo "Size: " . number_format($file['file_size']) . " bytes\n";
            echo "Uploaded: " . $file['uploaded_at'] . "\n";
            echo "---\n";
        }
    }
} catch (Exception $e) {
    echo "❌ Error querying media files: " . $e->getMessage() . "\n";
}

echo "\n✅ Database check completed!\n";
?>

