<?php
// Debug authentication issue
echo "🔐 Debug Authentication\n";
echo "======================\n\n";

// Test the same encryption as the server
$testDeviceId = "debug_test_" . time();
$timestamp = time() * 1000;
$apiKey = "monitoring_key_2024";
$encryptionKey = "monitoring_secret_key_2024";

// Simulate Android encryption
function androidEncrypt($data, $key) {
    $result = '';
    for ($i = 0; $i < strlen($data); $i++) {
        $result .= chr(ord($data[$i]) ^ ord($key[$i % strlen($key)]));
    }
    return $result;
}

// Simulate server encryption (should be the same)
function serverEncrypt($data, $key) {
    $result = '';
    for ($i = 0; $i < strlen($data); $i++) {
        $result .= chr(ord($data[$i]) ^ ord($key[$i % strlen($key)]));
    }
    return $result;
}

$authString = "$testDeviceId:$timestamp:$apiKey";
$androidToken = androidEncrypt($authString, $encryptionKey);
$serverToken = serverEncrypt($authString, $encryptionKey);

echo "Test Device ID: $testDeviceId\n";
echo "Timestamp: $timestamp\n";
echo "API Key: $apiKey\n";
echo "Encryption Key: $encryptionKey\n";
echo "Auth String: $authString\n";
echo "Android Token (first 20): " . substr($androidToken, 0, 20) . "...\n";
echo "Server Token (first 20): " . substr($serverToken, 0, 20) . "...\n";
echo "Tokens match: " . (hash_equals($androidToken, $serverToken) ? 'Yes' : 'No') . "\n\n";

// Test with the actual server
echo "Testing with server...\n";
$baseUrl = "http://mobiletr.upastithi.in/php/";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $baseUrl . "upload.php");
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, '{"test":"data"}');
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'X-Device-ID: ' . $testDeviceId,
    'X-Timestamp: ' . $timestamp,
    'X-Auth-Token: ' . $androidToken,
    'X-Data-Type: location',
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Status: $httpCode\n";
echo "Response: $response\n";

if ($httpCode === 401) {
    echo "\n❌ Authentication failed. This could be because:\n";
    echo "1. The encryption keys don't match between Android and server\n";
    echo "2. The server's database.php file hasn't been updated yet\n";
    echo "3. There's a timing issue with the timestamp\n";
    echo "4. The server is using different encryption logic\n";
}

echo "\n✅ Debug completed!\n";
?>
