<?php
// Server Diagnostic Script
echo "🔍 Server Diagnostic\n";
echo "===================\n\n";

$baseUrl = "http://mobiletr.upastithi.in/php/";

// Test 1: Check if our changes are live
echo "1️⃣ Checking if our changes are live...\n";
$apiUrl = $baseUrl . "api.php";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_NOBODY, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$headers = curl_getinfo($ch, CURLINFO_HEADER_OUT);
$responseHeaders = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
curl_close($ch);

echo "API HTTP Status: $httpCode\n";
echo "Response Headers:\n";
echo substr($response, 0, $responseHeaders) . "\n";

// Check if OPTIONS is in allowed methods
if (strpos($response, 'OPTIONS') !== false) {
    echo "✅ OPTIONS method is allowed (changes are live)\n";
} else {
    echo "❌ OPTIONS method not found in headers (changes not live)\n";
}

// Test 2: Check upload.php
echo "\n2️⃣ Checking upload.php...\n";
$uploadUrl = $baseUrl . "upload.php";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $uploadUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_NOBODY, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$responseHeaders = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
curl_close($ch);

echo "Upload HTTP Status: $httpCode\n";
echo "Response Headers:\n";
echo substr($response, 0, $responseHeaders) . "\n";

// Test 3: Test OPTIONS request
echo "\n3️⃣ Testing OPTIONS request...\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'OPTIONS');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$responseHeaders = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
curl_close($ch);

echo "OPTIONS HTTP Status: $httpCode\n";
echo "Response Headers:\n";
echo substr($response, 0, $responseHeaders) . "\n";

if ($httpCode === 200) {
    echo "✅ OPTIONS request successful\n";
} else {
    echo "❌ OPTIONS request failed\n";
}

// Test 4: Test with different HTTP methods
echo "\n4️⃣ Testing different HTTP methods...\n";
$methods = ['GET', 'POST', 'PUT', 'DELETE', 'PATCH'];

foreach ($methods as $method) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl . "?action=devices");
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "  $method: HTTP $httpCode\n";
}

// Test 5: Check server configuration
echo "\n5️⃣ Checking server configuration...\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $baseUrl . "phpinfo.php");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200 && strpos($response, 'PHP Version') !== false) {
    echo "✅ PHP info accessible\n";
    // Extract PHP version
    if (preg_match('/PHP Version ([0-9.]+)/', $response, $matches)) {
        echo "PHP Version: " . $matches[1] . "\n";
    }
} else {
    echo "❌ PHP info not accessible\n";
}

// Test 6: Check file permissions
echo "\n6️⃣ Checking file accessibility...\n";
$files = ['api.php', 'upload.php', 'auth.php', 'config/database.php'];

foreach ($files as $file) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $baseUrl . $file);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        echo "✅ $file is accessible\n";
    } else {
        echo "❌ $file returned HTTP $httpCode\n";
    }
}

echo "\n🔍 Diagnostic Summary\n";
echo "====================\n";
echo "If you see 405 errors, the server is rejecting the HTTP method.\n";
echo "If you see 400 errors with HTML, there might be a server configuration issue.\n";
echo "If OPTIONS is not in allowed methods, our changes haven't been uploaded.\n";
echo "\nNext steps:\n";
echo "1. Upload the updated files to your server\n";
echo "2. Check server error logs\n";
echo "3. Verify file permissions\n";
echo "4. Test with a simple GET request first\n";
?>
