<?php
// Comprehensive database credential finder
echo "🔍 Comprehensive Database Search\n";
echo "================================\n\n";

// First, let's try to connect without specifying a database to see what users exist
echo "1️⃣ Testing MySQL connection without database...\n";
$hosts = ['localhost', '127.0.0.1', 'localhost:3306'];
$users = ['root', 'mobiletr_upastithi', 'mobiletr', 'upastithi', 'admin'];
$passwords = ['', 'root', 'password', '123456', 'mobiletr_upastithi', 'mobiletr', 'upastithi'];

$found_connection = false;

foreach ($hosts as $host) {
    foreach ($users as $user) {
        foreach ($passwords as $password) {
            echo "Trying: $user@$host (password: " . ($password ?: 'empty') . ")\n";
            
            try {
                $dsn = "mysql:host=$host;charset=utf8mb4";
                $pdo = new PDO($dsn, $user, $password, [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                ]);
                
                echo "✅ Connected to MySQL! User: $user@$host\n";
                
                // Show available databases
                $stmt = $pdo->query("SHOW DATABASES");
                $databases = $stmt->fetchAll(PDO::FETCH_COLUMN);
                echo "Available databases:\n";
                foreach ($databases as $db) {
                    echo "  - $db\n";
                }
                
                // Look for monitoring-related databases
                $monitoring_dbs = array_filter($databases, function($db) {
                    return stripos($db, 'monitoring') !== false || 
                           stripos($db, 'mobiletr') !== false || 
                           stripos($db, 'upastithi') !== false;
                });
                
                if (!empty($monitoring_dbs)) {
                    echo "\n🎯 Found monitoring-related databases:\n";
                    foreach ($monitoring_dbs as $db) {
                        echo "  - $db\n";
                    }
                }
                
                $found_connection = true;
                break 3; // Break out of all loops
                
            } catch (PDOException $e) {
                // Silently continue to next combination
            }
        }
    }
}

if (!$found_connection) {
    echo "❌ Could not connect to MySQL with any common credentials.\n";
    echo "\nThis suggests:\n";
    echo "1. MySQL is not running\n";
    echo "2. Different port (try 3307, 3308)\n";
    echo "3. Different host (try your domain name)\n";
    echo "4. Custom credentials set by hosting provider\n";
}

// Test 2: Try connecting with domain name as host
echo "\n2️⃣ Testing with domain name as host...\n";
$domain_hosts = [
    'mobiletr.upastithi.in',
    'localhost.mobiletr.upastithi.in',
    'mysql.mobiletr.upastithi.in'
];

foreach ($domain_hosts as $host) {
    echo "Trying host: $host\n";
    try {
        $dsn = "mysql:host=$host;charset=utf8mb4";
        $pdo = new PDO($dsn, 'root', '', [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        ]);
        
        echo "✅ Connected to $host!\n";
        $stmt = $pdo->query("SHOW DATABASES");
        $databases = $stmt->fetchAll(PDO::FETCH_COLUMN);
        echo "Available databases:\n";
        foreach ($databases as $db) {
            echo "  - $db\n";
        }
        break;
        
    } catch (PDOException $e) {
        echo "❌ Failed: " . $e->getMessage() . "\n";
    }
}

// Test 3: Check if there's a config file with credentials
echo "\n3️⃣ Looking for existing configuration files...\n";
$config_files = [
    'config.php',
    'database.php',
    'db_config.php',
    'wp-config.php',
    '.env',
    'config.inc.php'
];

foreach ($config_files as $file) {
    if (file_exists($file)) {
        echo "Found: $file\n";
        $content = file_get_contents($file);
        
        // Look for database credentials in the file
        if (preg_match('/DB_HOST[\'"]?\s*[=:]\s*[\'"]([^\'"]+)[\'"]/', $content, $matches)) {
            echo "  DB_HOST: " . $matches[1] . "\n";
        }
        if (preg_match('/DB_NAME[\'"]?\s*[=:]\s*[\'"]([^\'"]+)[\'"]/', $content, $matches)) {
            echo "  DB_NAME: " . $matches[1] . "\n";
        }
        if (preg_match('/DB_USER[\'"]?\s*[=:]\s*[\'"]([^\'"]+)[\'"]/', $content, $matches)) {
            echo "  DB_USER: " . $matches[1] . "\n";
        }
        if (preg_match('/DB_PASS[\'"]?\s*[=:]\s*[\'"]([^\'"]+)[\'"]/', $content, $matches)) {
            echo "  DB_PASS: " . $matches[1] . "\n";
        }
    }
}

// Test 4: Check environment variables
echo "\n4️⃣ Checking environment variables...\n";
$env_vars = [
    'DB_HOST', 'DB_NAME', 'DB_USER', 'DB_PASS',
    'MYSQL_HOST', 'MYSQL_DATABASE', 'MYSQL_USER', 'MYSQL_PASSWORD',
    'DATABASE_HOST', 'DATABASE_NAME', 'DATABASE_USER', 'DATABASE_PASSWORD'
];

foreach ($env_vars as $var) {
    $value = getenv($var);
    if ($value) {
        echo "$var: $value\n";
    }
}

// Test 5: Check if we can create a database
echo "\n5️⃣ Testing database creation...\n";
if ($found_connection) {
    try {
        $test_db_name = 'monitoring_test_' . time();
        $pdo->exec("CREATE DATABASE IF NOT EXISTS $test_db_name");
        echo "✅ Successfully created test database: $test_db_name\n";
        
        // Test connection to the new database
        $dsn = "mysql:host=localhost;dbname=$test_db_name;charset=utf8mb4";
        $test_pdo = new PDO($dsn, 'root', '', [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        ]);
        
        echo "✅ Successfully connected to test database!\n";
        
        // Clean up
        $pdo->exec("DROP DATABASE $test_db_name");
        echo "✅ Test database cleaned up.\n";
        
        echo "\n🎉 SOLUTION: You can create a new database!\n";
        echo "Use these credentials in your database.php:\n";
        echo "define('DB_HOST', 'localhost');\n";
        echo "define('DB_NAME', 'monitoring_db');\n";
        echo "define('DB_USER', 'root');\n";
        echo "define('DB_PASS', '');\n";
        echo "\nThen run the database initialization script.\n";
        
    } catch (Exception $e) {
        echo "❌ Could not create database: " . $e->getMessage() . "\n";
    }
}

echo "\n✅ Comprehensive Database Search Completed!\n";
echo "==========================================\n";
echo "If no working credentials were found, you may need to:\n";
echo "1. Check your hosting control panel (cPanel, Plesk, etc.)\n";
echo "2. Look for 'MySQL Databases' or 'Database Management'\n";
echo "3. Create a new database and user\n";
echo "4. Contact your hosting provider for assistance\n";
?>
