<?php
// Upload this file to your server and run it to find the correct database credentials
echo "🔍 Finding Database Credentials\n";
echo "==============================\n\n";

// Common hosting patterns to try
$patterns = [
    // Pattern 1: Username-based
    [
        'host' => 'localhost',
        'dbname' => 'mobiletr_upastithi_monitoring',
        'user' => 'mobiletr_upastithi',
        'pass' => 'mobiletr_upastithi'
    ],
    [
        'host' => 'localhost',
        'dbname' => 'mobiletr_upastithi_monitoring_db',
        'user' => 'mobiletr_upastithi',
        'pass' => 'mobiletr_upastithi'
    ],
    // Pattern 2: Different ports
    [
        'host' => 'localhost:3306',
        'dbname' => 'monitoring_db',
        'user' => 'mobiletr_upastithi',
        'pass' => 'mobiletr_upastithi'
    ],
    [
        'host' => '127.0.0.1',
        'dbname' => 'monitoring_db',
        'user' => 'mobiletr_upastithi',
        'pass' => 'mobiletr_upastithi'
    ],
    // Pattern 3: Different database names
    [
        'host' => 'localhost',
        'dbname' => 'monitoring_db',
        'user' => 'mobiletr_upastithi',
        'pass' => 'mobiletr_upastithi'
    ],
    [
        'host' => 'localhost',
        'dbname' => 'mobiletr_monitoring',
        'user' => 'mobiletr_upastithi',
        'pass' => 'mobiletr_upastithi'
    ],
    // Pattern 4: Try with different passwords
    [
        'host' => 'localhost',
        'dbname' => 'monitoring_db',
        'user' => 'mobiletr_upastithi',
        'pass' => ''
    ],
    [
        'host' => 'localhost',
        'dbname' => 'monitoring_db',
        'user' => 'mobiletr_upastithi',
        'pass' => 'password'
    ],
    [
        'host' => 'localhost',
        'dbname' => 'monitoring_db',
        'user' => 'mobiletr_upastithi',
        'pass' => '123456'
    ]
];

$found = false;

foreach ($patterns as $i => $config) {
    echo "Testing pattern " . ($i + 1) . ": {$config['user']}@{$config['host']}/{$config['dbname']}\n";
    
    try {
        $dsn = "mysql:host={$config['host']};dbname={$config['dbname']};charset=utf8mb4";
        $pdo = new PDO($dsn, $config['user'], $config['pass'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
        
        echo "✅ SUCCESS! Found working configuration:\n";
        echo "   Host: {$config['host']}\n";
        echo "   Database: {$config['dbname']}\n";
        echo "   User: {$config['user']}\n";
        echo "   Password: {$config['pass']}\n\n";
        
        // Test if devices table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'devices'");
        if ($stmt->rowCount() > 0) {
            echo "✅ Devices table exists!\n";
            
            // Count devices
            $stmt = $pdo->query("SELECT COUNT(*) as count FROM devices");
            $result = $stmt->fetch();
            echo "📱 Found {$result['count']} devices in database\n";
            
            if ($result['count'] > 0) {
                // Show devices
                $stmt = $pdo->query("SELECT * FROM devices ORDER BY last_seen DESC LIMIT 5");
                $devices = $stmt->fetchAll();
                echo "Recent devices:\n";
                foreach ($devices as $device) {
                    echo "  - {$device['device_id']} ({$device['device_name']}) - {$device['last_seen']}\n";
                }
            }
        } else {
            echo "ℹ️ Devices table does not exist (will be created automatically)\n";
        }
        
        echo "\n🎉 UPDATE YOUR database.php FILE WITH THESE SETTINGS:\n";
        echo "define('DB_HOST', '{$config['host']}');\n";
        echo "define('DB_NAME', '{$config['dbname']}');\n";
        echo "define('DB_USER', '{$config['user']}');\n";
        echo "define('DB_PASS', '{$config['pass']}');\n";
        
        $found = true;
        break;
        
    } catch (PDOException $e) {
        echo "❌ Failed: " . $e->getMessage() . "\n";
    }
    echo "\n";
}

if (!$found) {
    echo "❌ No working configuration found.\n";
    echo "You may need to:\n";
    echo "1. Check your hosting control panel for database credentials\n";
    echo "2. Create a new database and user\n";
    echo "3. Contact your hosting provider for the correct credentials\n";
}

echo "\n✅ Database Credential Search Completed!\n";
?>
