<?php
// Test dashboard JavaScript functionality
echo "🧪 Testing Dashboard JavaScript Functionality\n";
echo "============================================\n\n";

// Test 1: Test API endpoints that dashboard uses
echo "1️⃣ Testing Dashboard API Endpoints...\n";

$baseUrl = "http://mobiletr.upastithi.in/php/";
$password = "admin123";

// Authenticate first
$authUrl = $baseUrl . "auth.php";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $authUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['password' => $password]));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIEJAR, '/tmp/dashboard_cookies.txt');
curl_setopt($ch, CURLOPT_COOKIEFILE, '/tmp/dashboard_cookies.txt');
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if ($httpCode === 200) {
    $data = json_decode($response, true);
    if ($data && isset($data['success']) && $data['success']) {
        echo "✅ Authentication successful!\n";
        
        // Test devices endpoint
        echo "\n2️⃣ Testing Devices Endpoint...\n";
        $devicesUrl = $baseUrl . "api.php?action=devices";
        curl_setopt($ch, CURLOPT_URL, $devicesUrl);
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
        if ($httpCode === 200) {
            $data = json_decode($response, true);
            if ($data && isset($data['success']) && $data['success']) {
                $devices = $data['data'];
                echo "✅ Devices endpoint working! Found " . count($devices) . " devices.\n";
                
                if (!empty($devices)) {
                    echo "Devices found:\n";
                    foreach ($devices as $device) {
                        echo "  📱 " . $device['device_id'] . " - " . $device['device_name'] . "\n";
                        echo "     Last seen: " . $device['last_seen'] . "\n";
                        echo "     Data: " . $device['call_count'] . " calls, " . $device['location_count'] . " locations, " . $device['media_count'] . " media\n";
                    }
                } else {
                    echo "ℹ️ No devices found in database.\n";
                }
            } else {
                echo "❌ Devices endpoint error: " . ($data['message'] ?? 'Unknown error') . "\n";
            }
        } else {
            echo "❌ Devices endpoint failed (HTTP $httpCode)\n";
        }
        
        // Test call logs endpoint
        echo "\n3️⃣ Testing Call Logs Endpoint...\n";
        $callsUrl = $baseUrl . "api.php?action=call_logs&limit=10";
        curl_setopt($ch, CURLOPT_URL, $callsUrl);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
        if ($httpCode === 200) {
            $data = json_decode($response, true);
            if ($data && isset($data['success']) && $data['success']) {
                $calls = $data['data'];
                echo "✅ Call logs endpoint working! Found " . count($calls) . " call logs.\n";
            } else {
                echo "❌ Call logs endpoint error: " . ($data['message'] ?? 'Unknown error') . "\n";
            }
        } else {
            echo "❌ Call logs endpoint failed (HTTP $httpCode)\n";
        }
        
        // Test locations endpoint
        echo "\n4️⃣ Testing Locations Endpoint...\n";
        $locationsUrl = $baseUrl . "api.php?action=locations&limit=10";
        curl_setopt($ch, CURLOPT_URL, $locationsUrl);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
        if ($httpCode === 200) {
            $data = json_decode($response, true);
            if ($data && isset($data['success']) && $data['success']) {
                $locations = $data['data'];
                echo "✅ Locations endpoint working! Found " . count($locations) . " location entries.\n";
            } else {
                echo "❌ Locations endpoint error: " . ($data['message'] ?? 'Unknown error') . "\n";
            }
        } else {
            echo "❌ Locations endpoint failed (HTTP $httpCode)\n";
        }
        
        // Test media endpoint
        echo "\n5️⃣ Testing Media Endpoint...\n";
        $mediaUrl = $baseUrl . "api.php?action=media&limit=10";
        curl_setopt($ch, CURLOPT_URL, $mediaUrl);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        
        if ($httpCode === 200) {
            $data = json_decode($response, true);
            if ($data && isset($data['success']) && $data['success']) {
                $media = $data['data'];
                echo "✅ Media endpoint working! Found " . count($media) . " media files.\n";
            } else {
                echo "❌ Media endpoint error: " . ($data['message'] ?? 'Unknown error') . "\n";
            }
        } else {
            echo "❌ Media endpoint failed (HTTP $httpCode)\n";
        }
        
    } else {
        echo "❌ Authentication failed: " . ($data['message'] ?? 'Unknown error') . "\n";
    }
} else {
    echo "❌ Authentication request failed (HTTP $httpCode)\n";
}

curl_close($ch);

// Cleanup
unlink('/tmp/dashboard_cookies.txt');

echo "\n✅ Dashboard JavaScript API Testing Completed!\n";
echo "=============================================\n";
echo "All API endpoints that the dashboard uses have been tested.\n";
echo "If all tests passed, your dashboard should work correctly!\n";
?>
