<?php
// Android Device Testing Script
// Run this after connecting your Android device via ADB

echo "📱 Android Device Testing\n";
echo "========================\n\n";

// Test 1: Check ADB Connection
echo "1️⃣ Checking ADB Connection...\n";
$adbDevices = shell_exec('adb devices 2>&1');
echo "ADB Output:\n$adbDevices\n";

if (strpos($adbDevices, 'device') !== false && strpos($adbDevices, 'List of devices') !== false) {
    echo "✅ ADB connection detected!\n";
    
    // Extract device ID
    $lines = explode("\n", $adbDevices);
    $deviceId = null;
    foreach ($lines as $line) {
        if (strpos($line, 'device') !== false && strpos($line, 'List of devices') === false) {
            $parts = explode("\t", $line);
            if (count($parts) >= 2) {
                $deviceId = trim($parts[0]);
                break;
            }
        }
    }
    
    if ($deviceId) {
        echo "📱 Connected Device ID: $deviceId\n";
    } else {
        echo "⚠️ Could not extract device ID from ADB output\n";
    }
} else {
    echo "❌ No ADB devices found!\n";
    echo "Make sure to:\n";
    echo "1. Enable Developer Options on your Android device\n";
    echo "2. Enable USB Debugging\n";
    echo "3. Connect device via USB\n";
    echo "4. Allow USB debugging when prompted\n";
    echo "5. Run: adb devices\n";
}

// Test 2: Check if Monitoring App is Installed
echo "\n2️⃣ Checking if Monitoring App is Installed...\n";
$packageName = "com.monitoring.app";
$appCheck = shell_exec("adb shell pm list packages | grep $packageName 2>&1");

if (strpos($appCheck, $packageName) !== false) {
    echo "✅ Monitoring app is installed!\n";
    
    // Get app version
    $versionInfo = shell_exec("adb shell dumpsys package $packageName | grep versionName 2>&1");
    if ($versionInfo) {
        echo "App version info: $versionInfo\n";
    }
} else {
    echo "❌ Monitoring app not found!\n";
    echo "Please install the APK first:\n";
    echo "1. Build the APK using Android Studio\n";
    echo "2. Install: adb install -r app-release.apk\n";
}

// Test 3: Check App Permissions
echo "\n3️⃣ Checking App Permissions...\n";
$permissions = [
    'android.permission.CAMERA',
    'android.permission.RECORD_AUDIO',
    'android.permission.ACCESS_FINE_LOCATION',
    'android.permission.ACCESS_COARSE_LOCATION',
    'android.permission.READ_EXTERNAL_STORAGE',
    'android.permission.WRITE_EXTERNAL_STORAGE',
    'android.permission.READ_CONTACTS',
    'android.permission.READ_CALL_LOG',
    'android.permission.READ_PHONE_STATE',
    'android.permission.VIBRATE',
    'android.permission.POST_NOTIFICATIONS'
];

foreach ($permissions as $permission) {
    $permissionCheck = shell_exec("adb shell dumpsys package $packageName | grep $permission 2>&1");
    if (strpos($permissionCheck, 'granted=true') !== false) {
        echo "✅ $permission - Granted\n";
    } else {
        echo "❌ $permission - Not granted\n";
    }
}

// Test 4: Check App Logs
echo "\n4️⃣ Checking App Logs...\n";
$logOutput = shell_exec("adb logcat -d | grep -i 'monitoring\\|ScreenCapture\\|HttpClient' | tail -20 2>&1");
if ($logOutput) {
    echo "Recent app logs:\n$logOutput\n";
} else {
    echo "ℹ️ No recent monitoring logs found\n";
    echo "Try running the app and check logs again\n";
}

// Test 5: Test Network Connectivity
echo "\n5️⃣ Testing Network Connectivity...\n";
$pingTest = shell_exec("adb shell ping -c 3 mobiletr.upastithi.in 2>&1");
if (strpos($pingTest, '3 packets transmitted') !== false) {
    echo "✅ Network connectivity to server is working!\n";
} else {
    echo "❌ Network connectivity issues detected\n";
    echo "Make sure your Android device has internet access\n";
}

// Test 6: Check App Data Directory
echo "\n6️⃣ Checking App Data Directory...\n";
$dataDir = shell_exec("adb shell ls -la /data/data/$packageName/ 2>&1");
if (strpos($dataDir, 'No such file') === false) {
    echo "✅ App data directory exists\n";
    echo "Data directory contents:\n$dataDir\n";
} else {
    echo "❌ App data directory not found\n";
    echo "The app may not have been run yet\n";
}

// Test 7: Check Shared Preferences
echo "\n7️⃣ Checking App Shared Preferences...\n";
$prefsFile = "/data/data/$packageName/shared_prefs/monitoring_prefs.xml";
$prefsContent = shell_exec("adb shell cat $prefsFile 2>&1");
if (strpos($prefsContent, 'No such file') === false) {
    echo "✅ Shared preferences file exists\n";
    echo "Preferences content:\n$prefsContent\n";
} else {
    echo "ℹ️ Shared preferences file not found\n";
    echo "This is normal if the app hasn't been run yet\n";
}

// Test 8: Monitor Real-time Logs
echo "\n8️⃣ Monitoring Real-time Logs (10 seconds)...\n";
echo "Starting log monitoring... (Press Ctrl+C to stop)\n";
echo "Now try running your monitoring app!\n\n";

$startTime = time();
$logFile = '/tmp/android_logs.txt';

// Start logcat in background
$pid = popen("adb logcat -v time | grep -i 'monitoring\\|ScreenCapture\\|HttpClient\\|MainActivity' > $logFile 2>&1 &", 'r');
pclose($pid);

// Monitor for 10 seconds
while ((time() - $startTime) < 10) {
    if (file_exists($logFile)) {
        $logs = file_get_contents($logFile);
        if ($logs) {
            echo "New logs detected:\n$logs\n";
            // Clear the log file
            file_put_contents($logFile, '');
        }
    }
    sleep(1);
}

// Kill the background process
shell_exec("pkill -f 'adb logcat'");

echo "\n✅ Android Device Testing Completed!\n";
echo "===================================\n";
echo "Next steps:\n";
echo "1. Make sure all permissions are granted\n";
echo "2. Run the monitoring app\n";
echo "3. Check the dashboard at: http://mobiletr.upastithi.in/dashboard/\n";
echo "4. Login with password: admin123\n";
echo "5. Your device should appear in the devices list!\n";
?>

