<?php
// Test dashboard authentication and API access
echo "🔐 Testing Dashboard Authentication\n";
echo "==================================\n\n";

// Test 1: Test authentication endpoint
echo "1️⃣ Testing Authentication Endpoint...\n";
$authUrl = "http://mobiletr.upastithi.in/php/auth.php";
$password = "admin123"; // Default password from config

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $authUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['password' => $password]));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Cookie: PHPSESSID=test_session_' . time()
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIEJAR, '/tmp/cookies.txt');
curl_setopt($ch, CURLOPT_COOKIEFILE, '/tmp/cookies.txt');

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

if ($error) {
    echo "❌ cURL Error: $error\n";
} else {
    echo "HTTP Status Code: $httpCode\n";
    echo "Response: $response\n";
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            echo "✅ Authentication successful!\n";
        } else {
            echo "❌ Authentication failed: " . ($data['message'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ HTTP request failed with status $httpCode\n";
    }
}

// Test 2: Test API endpoint with authentication
echo "\n2️⃣ Testing API Endpoint with Authentication...\n";
$apiUrl = "http://mobiletr.upastithi.in/php/api.php?action=devices";

// Use the same session cookies
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, false);
curl_setopt($ch, CURLOPT_HTTPGET, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ cURL Error: $error\n";
} else {
    echo "HTTP Status Code: $httpCode\n";
    echo "Response: $response\n";
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            $devices = $data['data'];
            echo "✅ API endpoint working! Found " . count($devices) . " devices.\n";
            
            if (!empty($devices)) {
                echo "Devices in database:\n";
                foreach ($devices as $device) {
                    echo "  - " . $device['device_id'] . " (" . $device['device_name'] . ")\n";
                    echo "    Last seen: " . $device['last_seen'] . "\n";
                    echo "    Call count: " . $device['call_count'] . "\n";
                    echo "    Location count: " . $device['location_count'] . "\n";
                    echo "    Media count: " . $device['media_count'] . "\n";
                    echo "    ---\n";
                }
            } else {
                echo "No devices found in database.\n";
            }
        } else {
            echo "❌ API returned error: " . ($data['message'] ?? 'Unknown error') . "\n";
        }
    } elseif ($httpCode === 401) {
        echo "❌ API requires authentication (401 Unauthorized)\n";
        echo "This means the session cookie didn't work properly.\n";
    } else {
        echo "❌ HTTP request failed with status $httpCode\n";
    }
}

// Test 3: Test dashboard access
echo "\n3️⃣ Testing Dashboard Access...\n";
$dashboardUrl = "http://mobiletr.upastithi.in/dashboard/";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $dashboardUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ cURL Error: $error\n";
} else {
    echo "HTTP Status Code: $httpCode\n";
    if ($httpCode === 200) {
        echo "✅ Dashboard is accessible!\n";
        if (strpos($response, 'loginModal') !== false) {
            echo "✅ Login modal is present in the dashboard.\n";
        } else {
            echo "❌ Login modal not found in dashboard HTML.\n";
        }
    } else {
        echo "❌ Dashboard not accessible (HTTP $httpCode)\n";
    }
}

// Clean up
unlink('/tmp/cookies.txt');

echo "\n🎉 Dashboard Authentication Test Completed!\n";
echo "==========================================\n";
echo "To access your dashboard:\n";
echo "1. Go to: http://mobiletr.upastithi.in/dashboard/\n";
echo "2. Enter password: admin123\n";
echo "3. Click Login\n";
?>

