<?php
// Database Configuration Test
echo "🗄️ Database Configuration Test\n";
echo "==============================\n\n";

// Test different database configurations
$configs = [
    'Default (root, no password)' => [
        'host' => 'localhost',
        'dbname' => 'monitoring_db',
        'user' => 'root',
        'pass' => ''
    ],
    'Root with password' => [
        'host' => 'localhost',
        'dbname' => 'monitoring_db',
        'user' => 'root',
        'pass' => 'root'
    ],
    'Common hosting user' => [
        'host' => 'localhost',
        'dbname' => 'monitoring_db',
        'user' => 'mobiletr_upastithi',
        'pass' => 'mobiletr_upastithi'
    ],
    'Database name variations' => [
        'host' => 'localhost',
        'dbname' => 'mobiletr_upastithi_monitoring',
        'user' => 'mobiletr_upastithi',
        'pass' => 'mobiletr_upastithi'
    ]
];

foreach ($configs as $name => $config) {
    echo "Testing: $name\n";
    echo "Host: {$config['host']}, DB: {$config['dbname']}, User: {$config['user']}\n";
    
    try {
        $dsn = "mysql:host={$config['host']};dbname={$config['dbname']};charset=utf8mb4";
        $pdo = new PDO($dsn, $config['user'], $config['pass'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ]);
        
        echo "✅ Connection successful!\n";
        
        // Test if devices table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'devices'");
        if ($stmt->rowCount() > 0) {
            echo "✅ Devices table exists!\n";
            
            // Count devices
            $stmt = $pdo->query("SELECT COUNT(*) as count FROM devices");
            $result = $stmt->fetch();
            echo "📱 Found {$result['count']} devices in database\n";
            
            if ($result['count'] > 0) {
                // Show devices
                $stmt = $pdo->query("SELECT * FROM devices ORDER BY last_seen DESC LIMIT 5");
                $devices = $stmt->fetchAll();
                echo "Recent devices:\n";
                foreach ($devices as $device) {
                    echo "  - {$device['device_id']} ({$device['device_name']}) - {$device['last_seen']}\n";
                }
            }
        } else {
            echo "❌ Devices table does not exist!\n";
        }
        
        echo "---\n";
        break; // Stop at first successful connection
        
    } catch (PDOException $e) {
        echo "❌ Connection failed: " . $e->getMessage() . "\n";
        echo "---\n";
    }
}

// Test 2: Check what databases exist
echo "\n🔍 Checking Available Databases...\n";
$configs_to_try = [
    ['host' => 'localhost', 'user' => 'root', 'pass' => ''],
    ['host' => 'localhost', 'user' => 'root', 'pass' => 'root'],
    ['host' => 'localhost', 'user' => 'mobiletr_upastithi', 'pass' => 'mobiletr_upastithi'],
];

foreach ($configs_to_try as $config) {
    echo "Trying user: {$config['user']}\n";
    try {
        $dsn = "mysql:host={$config['host']};charset=utf8mb4";
        $pdo = new PDO($dsn, $config['user'], $config['pass'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        ]);
        
        echo "✅ Connected! Available databases:\n";
        $stmt = $pdo->query("SHOW DATABASES");
        $databases = $stmt->fetchAll(PDO::FETCH_COLUMN);
        foreach ($databases as $db) {
            echo "  - $db\n";
        }
        break;
        
    } catch (PDOException $e) {
        echo "❌ Failed: " . $e->getMessage() . "\n";
    }
}

echo "\n✅ Database Configuration Test Completed!\n";
echo "========================================\n";
echo "If you found a working configuration, update your database.php file!\n";
?>
