<?php
// Test database connection and setup
require_once 'config/database.php';

echo "Testing database connection...\n";

// Test connection
$pdo = getDatabaseConnection();
if (!$pdo) {
    echo "❌ Database connection failed!\n";
    echo "Please check your database configuration in php/config/database.php\n";
    echo "Make sure MySQL is running and the database 'monitoring_db' exists.\n";
    exit(1);
}

echo "✅ Database connection successful!\n";

// Test database initialization
echo "Initializing database tables...\n";
if (initializeDatabase()) {
    echo "✅ Database tables initialized successfully!\n";
} else {
    echo "❌ Database initialization failed!\n";
    exit(1);
}

// Test device registration
echo "Testing device registration...\n";
try {
    $testDeviceId = "test_device_" . time();
    $stmt = $pdo->prepare("
        INSERT INTO devices (device_id, device_name) 
        VALUES (?, ?) 
        ON DUPLICATE KEY UPDATE last_seen = CURRENT_TIMESTAMP
    ");
    $result = $stmt->execute([$testDeviceId, "Test Device"]);
    
    if ($result) {
        echo "✅ Device registration test successful!\n";
        
        // Clean up test device
        $stmt = $pdo->prepare("DELETE FROM devices WHERE device_id = ?");
        $stmt->execute([$testDeviceId]);
        echo "✅ Test device cleaned up.\n";
    } else {
        echo "❌ Device registration test failed!\n";
    }
} catch (Exception $e) {
    echo "❌ Device registration test failed: " . $e->getMessage() . "\n";
}

// Test API endpoint
echo "Testing API endpoint...\n";
$apiUrl = "http://localhost/php/api.php?action=devices";
$response = file_get_contents($apiUrl);
if ($response) {
    $data = json_decode($response, true);
    if ($data && isset($data['success']) && $data['success']) {
        echo "✅ API endpoint working! Found " . count($data['data']) . " devices.\n";
    } else {
        echo "❌ API endpoint returned error: " . $response . "\n";
    }
} else {
    echo "❌ API endpoint not accessible!\n";
}

echo "\n🎉 Database setup test completed!\n";
echo "If all tests passed, your monitoring system should work correctly.\n";
?>
