<?php
// Final device registration test with correct authentication
echo "📱 Final Device Registration Test\n";
echo "=================================\n\n";

$baseUrl = "http://mobiletr.upastithi.in/php/";

// Test device registration with correct authentication
$testDeviceId = "final_test_" . time();
$timestamp = time() * 1000;
$apiKey = "monitoring_key_2024";
$encryptionKey = "monitoring_secret_key_2024";

// Simulate Android encryption
function androidEncrypt($data, $key) {
    $result = '';
    for ($i = 0; $i < strlen($data); $i++) {
        $result .= chr(ord($data[$i]) ^ ord($key[$i % strlen($key)]));
    }
    return $result;
}

$locationData = [
    'latitude' => 28.6139,
    'longitude' => 77.2090,
    'accuracy' => 10.5,
    'timestamp' => $timestamp,
    'address' => 'New Delhi, India'
];

$encryptedData = androidEncrypt(json_encode($locationData), $encryptionKey);
$authToken = androidEncrypt("$testDeviceId:$timestamp:$apiKey", $encryptionKey);

echo "Test Device ID: $testDeviceId\n";
echo "Timestamp: $timestamp\n";
echo "Auth Token (first 20 chars): " . substr($authToken, 0, 20) . "...\n\n";

// Test 1: Register device via upload.php
echo "1️⃣ Testing Device Registration...\n";
$uploadUrl = $baseUrl . "upload.php";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $uploadUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encryptedData);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'X-Device-ID: ' . $testDeviceId,
    'X-Timestamp: ' . $timestamp,
    'X-Auth-Token: ' . $authToken,
    'X-Data-Type: location',
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ cURL Error: $error\n";
} else {
    echo "HTTP Status: $httpCode\n";
    echo "Response: $response\n";
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            echo "✅ Device registration successful!\n";
        } else {
            echo "❌ Device registration failed: " . ($data['message'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ Upload request failed (HTTP $httpCode)\n";
    }
}

// Test 2: Check if device appears in database
echo "\n2️⃣ Checking if Device Appears in Database...\n";
$devicesUrl = $baseUrl . "public_api.php?action=devices";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $devicesUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ cURL Error: $error\n";
} else {
    echo "HTTP Status: $httpCode\n";
    echo "Response: $response\n";
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            $devices = $data['data'];
            echo "✅ Database check successful! Found " . count($devices) . " devices.\n";
            
            if (!empty($devices)) {
                echo "Devices in database:\n";
                foreach ($devices as $device) {
                    echo "  📱 Device ID: " . $device['device_id'] . "\n";
                    echo "     Name: " . $device['device_name'] . "\n";
                    echo "     Last Seen: " . $device['last_seen'] . "\n";
                    echo "     ---\n";
                }
                
                // Check if our test device is there
                $found = false;
                foreach ($devices as $device) {
                    if ($device['device_id'] === $testDeviceId) {
                        $found = true;
                        echo "✅ Test device found in database!\n";
                        break;
                    }
                }
                
                if (!$found) {
                    echo "❌ Test device not found in database.\n";
                }
            } else {
                echo "ℹ️ No devices found in database.\n";
            }
        } else {
            echo "❌ Database check failed: " . ($data['message'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ Database check failed (HTTP $httpCode)\n";
    }
}

echo "\n✅ Final Device Registration Test Completed!\n";
echo "===========================================\n";
echo "If the test device appears in the database, everything is working!\n";
echo "Your Android app should now be able to register devices successfully.\n";
echo "Check your dashboard at: http://mobiletr.upastithi.in/dashboard/\n";
?>
