<?php
// Simple HTTP test to identify the 400 error
echo "🌐 Simple HTTP Test\n";
echo "==================\n\n";

$baseUrl = "http://mobiletr.upastithi.in/php/";

// Test 1: Test with minimal headers
echo "1️⃣ Testing with minimal headers...\n";
$uploadUrl = $baseUrl . "upload.php";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $uploadUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, '{"test":"data"}');
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_VERBOSE, true);
curl_setopt($ch, CURLOPT_STDERR, fopen('/tmp/curl_verbose.log', 'w'));
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
$info = curl_getinfo($ch);
curl_close($ch);

echo "HTTP Status: $httpCode\n";
echo "Response: " . substr($response, 0, 200) . "...\n";
echo "Error: $error\n";
echo "Info: " . print_r($info, true) . "\n";

if (file_exists('/tmp/curl_verbose.log')) {
    echo "CURL Verbose Log:\n";
    echo file_get_contents('/tmp/curl_verbose.log') . "\n";
    unlink('/tmp/curl_verbose.log');
}

// Test 2: Test with different content types
echo "\n2️⃣ Testing with different content types...\n";
$contentTypes = [
    'application/json',
    'application/x-www-form-urlencoded',
    'text/plain',
    'multipart/form-data'
];

foreach ($contentTypes as $contentType) {
    echo "Testing Content-Type: $contentType\n";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $uploadUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, '{"test":"data"}');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: $contentType"
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "  HTTP Status: $httpCode\n";
    if ($httpCode !== 400) {
        echo "  ✅ This content type works!\n";
    } else {
        echo "  ❌ Still getting 400 error\n";
    }
}

// Test 3: Test with GET request
echo "\n3️⃣ Testing with GET request...\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $uploadUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "GET HTTP Status: $httpCode\n";
echo "GET Response: " . substr($response, 0, 200) . "...\n";

// Test 4: Test server configuration
echo "\n4️⃣ Testing server configuration...\n";
$testUrl = $baseUrl . "test_server.php";

// Create a simple test file content
$testContent = '<?php echo "Server test successful!"; ?>';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "Test file HTTP Status: $httpCode\n";
echo "Test file Response: $response\n";

// Test 5: Check if it's a server-level issue
echo "\n5️⃣ Testing with different user agents...\n";
$userAgents = [
    'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
    'curl/7.68.0',
    'Android App',
    'Monitoring App'
];

foreach ($userAgents as $ua) {
    echo "Testing User-Agent: $ua\n";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $uploadUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, '{"test":"data"}');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        "User-Agent: $ua"
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "  HTTP Status: $httpCode\n";
}

echo "\n✅ Simple HTTP Test Completed!\n";
echo "=============================\n";
echo "If all tests return 400, the issue is likely:\n";
echo "1. Server configuration blocking requests\n";
echo "2. Web server (LiteSpeed) security rules\n";
echo "3. PHP configuration issues\n";
echo "4. File permissions or .htaccess rules\n";
?>
