<?php
// Test public API (no authentication required)
echo "🌐 Testing Public API\n";
echo "====================\n\n";

$baseUrl = "http://mobiletr.upastithi.in/php/";

// Test 1: Test public API basic functionality
echo "1️⃣ Testing Public API Basic Functionality...\n";
$testUrl = $baseUrl . "public_api.php?action=test";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ cURL Error: $error\n";
} else {
    echo "HTTP Status: $httpCode\n";
    echo "Response: $response\n";
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            echo "✅ Public API is working!\n";
        } else {
            echo "❌ Public API returned error: " . ($data['message'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ Public API request failed (HTTP $httpCode)\n";
    }
}

// Test 2: Test devices endpoint
echo "\n2️⃣ Testing Devices Endpoint...\n";
$devicesUrl = $baseUrl . "public_api.php?action=devices";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $devicesUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ cURL Error: $error\n";
} else {
    echo "HTTP Status: $httpCode\n";
    echo "Response: $response\n";
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            $devices = $data['data'];
            echo "✅ Devices endpoint working! Found " . count($devices) . " devices.\n";
            
            if (!empty($devices)) {
                echo "Devices in database:\n";
                foreach ($devices as $device) {
                    echo "  📱 Device ID: " . $device['device_id'] . "\n";
                    echo "     Name: " . $device['device_name'] . "\n";
                    echo "     Last Seen: " . $device['last_seen'] . "\n";
                    echo "     Call Count: " . $device['call_count'] . "\n";
                    echo "     Location Count: " . $device['location_count'] . "\n";
                    echo "     Media Count: " . $device['media_count'] . "\n";
                    echo "     ---\n";
                }
            } else {
                echo "ℹ️ No devices found in database.\n";
                echo "This means either:\n";
                echo "- No Android devices have connected yet\n";
                echo "- Device registration is failing\n";
                echo "- There's an issue with the upload.php endpoint\n";
            }
        } else {
            echo "❌ Devices endpoint error: " . ($data['message'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ Devices endpoint failed (HTTP $httpCode)\n";
    }
}

// Test 3: Test locations endpoint
echo "\n3️⃣ Testing Locations Endpoint...\n";
$locationsUrl = $baseUrl . "public_api.php?action=locations&limit=5";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $locationsUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ cURL Error: $error\n";
} else {
    echo "HTTP Status: $httpCode\n";
    echo "Response: $response\n";
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            $locations = $data['data'];
            echo "✅ Locations endpoint working! Found " . count($locations) . " location entries.\n";
            
            if (!empty($locations)) {
                echo "Recent locations:\n";
                foreach ($locations as $location) {
                    echo "  📍 Device: " . $location['device_id'] . "\n";
                    echo "     Location: " . $location['latitude'] . ", " . $location['longitude'] . "\n";
                    echo "     Address: " . $location['address'] . "\n";
                    echo "     Time: " . date('Y-m-d H:i:s', $location['timestamp'] / 1000) . "\n";
                    echo "     ---\n";
                }
            } else {
                echo "ℹ️ No location data found.\n";
            }
        } else {
            echo "❌ Locations endpoint error: " . ($data['message'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ Locations endpoint failed (HTTP $httpCode)\n";
    }
}

// Test 4: Test media endpoint
echo "\n4️⃣ Testing Media Endpoint...\n";
$mediaUrl = $baseUrl . "public_api.php?action=media&limit=5";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $mediaUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ cURL Error: $error\n";
} else {
    echo "HTTP Status: $httpCode\n";
    echo "Response: $response\n";
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            $media = $data['data'];
            echo "✅ Media endpoint working! Found " . count($media) . " media files.\n";
            
            if (!empty($media)) {
                echo "Recent media files:\n";
                foreach ($media as $file) {
                    echo "  📁 Device: " . $file['device_id'] . "\n";
                    echo "     File: " . $file['file_name'] . "\n";
                    echo "     Type: " . $file['file_type'] . "\n";
                    echo "     Size: " . number_format($file['file_size']) . " bytes\n";
                    echo "     Uploaded: " . $file['uploaded_at'] . "\n";
                    echo "     ---\n";
                }
            } else {
                echo "ℹ️ No media files found.\n";
            }
        } else {
            echo "❌ Media endpoint error: " . ($data['message'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ Media endpoint failed (HTTP $httpCode)\n";
    }
}

echo "\n✅ Public API Testing Completed!\n";
echo "===============================\n";
echo "If you see devices in the response, they should appear in your dashboard!\n";
echo "If you don't see any devices, the issue is with device registration.\n";
echo "\nTo test the dashboard:\n";
echo "1. Go to: http://mobiletr.upastithi.in/dashboard/\n";
echo "2. Open browser developer tools (F12)\n";
echo "3. Check the Console tab for JavaScript errors\n";
echo "4. Check the Network tab to see if API calls are failing\n";
?>
