<?php
// Test database connection on the server
echo "🗄️ Testing Database Connection on Server\n";
echo "=======================================\n\n";

// Test the credentials you provided
$DB_HOST = 'localhost';
$DB_NAME = 'swaminar_mobiletr';
$DB_USER = 'swaminar_mobiletr';
$DB_PASS = 'Ashish123@';

echo "Testing credentials:\n";
echo "Host: $DB_HOST\n";
echo "Database: $DB_NAME\n";
echo "User: $DB_USER\n";
echo "Password: " . substr($DB_PASS, 0, 3) . "***\n\n";

try {
    echo "1️⃣ Testing database connection...\n";
    $dsn = "mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4";
    $pdo = new PDO($dsn, $DB_USER, $DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);
    echo "✅ Database connection successful!\n\n";
    
    // Check if tables exist
    echo "2️⃣ Checking existing tables...\n";
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    if (empty($tables)) {
        echo "ℹ️ No tables found in database.\n";
        echo "This is normal for a new database.\n";
    } else {
        echo "Found " . count($tables) . " tables:\n";
        foreach ($tables as $table) {
            echo "  - $table\n";
        }
    }
    
    // Check if devices table exists
    if (in_array('devices', $tables)) {
        echo "\n3️⃣ Checking devices table...\n";
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM devices");
        $result = $stmt->fetch();
        echo "Found {$result['count']} devices in database.\n";
        
        if ($result['count'] > 0) {
            $stmt = $pdo->query("SELECT * FROM devices ORDER BY last_seen DESC LIMIT 5");
            $devices = $stmt->fetchAll();
            echo "Recent devices:\n";
            foreach ($devices as $device) {
                echo "  - {$device['device_id']} ({$device['device_name']}) - {$device['last_seen']}\n";
            }
        }
    } else {
        echo "\n3️⃣ Devices table does not exist. Creating it...\n";
        
        // Create devices table
        $pdo->exec("CREATE TABLE IF NOT EXISTS devices (
            id INT AUTO_INCREMENT PRIMARY KEY,
            device_id VARCHAR(255) UNIQUE NOT NULL,
            device_name VARCHAR(255),
            last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )");
        echo "✅ Devices table created!\n";
        
        // Create other tables
        $pdo->exec("CREATE TABLE IF NOT EXISTS call_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            device_id VARCHAR(255) NOT NULL,
            timestamp BIGINT NOT NULL,
            duration BIGINT NOT NULL,
            type VARCHAR(20) NOT NULL,
            number VARCHAR(50) NOT NULL,
            contact_name VARCHAR(255),
            latitude DECIMAL(10, 8),
            longitude DECIMAL(11, 8),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX idx_device_timestamp (device_id, timestamp)
        )");
        echo "✅ Call logs table created!\n";
        
        $pdo->exec("CREATE TABLE IF NOT EXISTS locations (
            id INT AUTO_INCREMENT PRIMARY KEY,
            device_id VARCHAR(255) NOT NULL,
            latitude DECIMAL(10, 8) NOT NULL,
            longitude DECIMAL(11, 8) NOT NULL,
            accuracy FLOAT,
            timestamp BIGINT NOT NULL,
            address TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX idx_device_timestamp (device_id, timestamp)
        )");
        echo "✅ Locations table created!\n";
        
        $pdo->exec("CREATE TABLE IF NOT EXISTS media_files (
            id INT AUTO_INCREMENT PRIMARY KEY,
            device_id VARCHAR(255) NOT NULL,
            file_name VARCHAR(255) NOT NULL,
            file_path VARCHAR(500) NOT NULL,
            file_size BIGINT NOT NULL,
            mime_type VARCHAR(100) NOT NULL,
            file_type VARCHAR(20) NOT NULL,
            timestamp BIGINT NOT NULL,
            uploaded_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX idx_device_type (device_id, file_type),
            INDEX idx_timestamp (timestamp)
        )");
        echo "✅ Media files table created!\n";
        
        $pdo->exec("CREATE TABLE IF NOT EXISTS remote_commands (
            id INT AUTO_INCREMENT PRIMARY KEY,
            device_id VARCHAR(255) NOT NULL,
            command_type VARCHAR(50) NOT NULL,
            command_param TEXT,
            status VARCHAR(20) DEFAULT 'pending',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            executed_at TIMESTAMP NULL,
            INDEX idx_device_status (device_id, status)
        )");
        echo "✅ Remote commands table created!\n";
    }
    
    // Test device registration
    echo "\n4️⃣ Testing device registration...\n";
    $testDeviceId = "server_test_" . time();
    $stmt = $pdo->prepare("
        INSERT INTO devices (device_id, device_name) 
        VALUES (?, ?) 
        ON DUPLICATE KEY UPDATE last_seen = CURRENT_TIMESTAMP
    ");
    $result = $stmt->execute([$testDeviceId, "Server Test Device"]);
    
    if ($result) {
        echo "✅ Device registration successful!\n";
        
        // Verify device exists
        $stmt = $pdo->prepare("SELECT * FROM devices WHERE device_id = ?");
        $stmt->execute([$testDeviceId]);
        $device = $stmt->fetch();
        
        if ($device) {
            echo "✅ Device found in database!\n";
            echo "  Device ID: " . $device['device_id'] . "\n";
            echo "  Name: " . $device['device_name'] . "\n";
            echo "  Last Seen: " . $device['last_seen'] . "\n";
        }
        
        // Clean up test device
        $stmt = $pdo->prepare("DELETE FROM devices WHERE device_id = ?");
        $stmt->execute([$testDeviceId]);
        echo "✅ Test device cleaned up.\n";
    } else {
        echo "❌ Device registration failed!\n";
    }
    
    echo "\n🎉 Database setup completed successfully!\n";
    echo "========================================\n";
    echo "Your monitoring system is now ready!\n";
    echo "1. Upload the updated database.php file to your server\n";
    echo "2. Your Android app should now be able to register devices\n";
    echo "3. Check your dashboard at: http://mobiletr.upastithi.in/dashboard/\n";
    
} catch (PDOException $e) {
    echo "❌ Database error: " . $e->getMessage() . "\n";
    echo "\nPossible solutions:\n";
    echo "1. Check if the database name is correct\n";
    echo "2. Check if the user has proper permissions\n";
    echo "3. Try a different host (127.0.0.1 instead of localhost)\n";
    echo "4. Check if MySQL is running on a different port\n";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
