<?php
// Simple API test without authentication
echo "🔧 Simple API Test\n";
echo "=================\n\n";

$baseUrl = "http://mobiletr.upastithi.in/php/";

// Test 1: Test API without authentication (should fail)
echo "1️⃣ Testing API without authentication...\n";
$apiUrl = $baseUrl . "api.php?action=devices";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ cURL Error: $error\n";
} else {
    echo "HTTP Status: $httpCode\n";
    echo "Response: $response\n";
    
    if ($httpCode === 401) {
        echo "✅ API correctly requires authentication (401 Unauthorized)\n";
    } else {
        echo "❌ Unexpected response (expected 401)\n";
    }
}

// Test 2: Test authentication
echo "\n2️⃣ Testing authentication...\n";
$authUrl = $baseUrl . "auth.php";
$password = "admin123";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $authUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['password' => $password]));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIEJAR, '/tmp/simple_cookies.txt');
curl_setopt($ch, CURLOPT_COOKIEFILE, '/tmp/simple_cookies.txt');
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

if ($error) {
    echo "❌ Auth Error: $error\n";
} else {
    echo "Auth HTTP Status: $httpCode\n";
    echo "Auth Response: $response\n";
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            echo "✅ Authentication successful!\n";
        } else {
            echo "❌ Authentication failed: " . ($data['message'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ Authentication request failed (HTTP $httpCode)\n";
    }
}

// Test 3: Test API with authentication
echo "\n3️⃣ Testing API with authentication...\n";
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, false);
curl_setopt($ch, CURLOPT_HTTPGET, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ API Error: $error\n";
} else {
    echo "API HTTP Status: $httpCode\n";
    echo "API Response: $response\n";
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            $devices = $data['data'];
            echo "✅ API working! Found " . count($devices) . " devices.\n";
            
            if (!empty($devices)) {
                echo "Devices in database:\n";
                foreach ($devices as $device) {
                    echo "  📱 " . $device['device_id'] . " - " . $device['device_name'] . "\n";
                    echo "     Last seen: " . $device['last_seen'] . "\n";
                }
            } else {
                echo "ℹ️ No devices found in database.\n";
            }
        } else {
            echo "❌ API returned error: " . ($data['message'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ API request failed (HTTP $httpCode)\n";
    }
}

// Test 4: Test upload endpoint
echo "\n4️⃣ Testing upload endpoint...\n";
$uploadUrl = $baseUrl . "upload.php";
$testDeviceId = "simple_test_" . time();
$timestamp = time() * 1000;
$apiKey = "monitoring_key_2024";
$encryptionKey = "monitoring_secret_key_2024";

// Simulate Android encryption
function androidEncrypt($data, $key) {
    $result = '';
    for ($i = 0; $i < strlen($data); $i++) {
        $result .= chr(ord($data[$i]) ^ ord($key[$i % strlen($key)]));
    }
    return $result;
}

$locationData = [
    'latitude' => 28.6139,
    'longitude' => 77.2090,
    'accuracy' => 10.5,
    'timestamp' => $timestamp,
    'address' => 'New Delhi, India'
];

$encryptedData = androidEncrypt(json_encode($locationData), $encryptionKey);
$authToken = androidEncrypt("$testDeviceId:$timestamp:$apiKey", $encryptionKey);

$headers = [
    'X-Device-ID: ' . $testDeviceId,
    'X-Timestamp: ' . $timestamp,
    'X-Auth-Token: ' . $authToken,
    'X-Data-Type: location',
    'Content-Type: application/json'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $uploadUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encryptedData);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "❌ Upload Error: $error\n";
} else {
    echo "Upload HTTP Status: $httpCode\n";
    echo "Upload Response: $response\n";
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        if ($data && isset($data['success']) && $data['success']) {
            echo "✅ Device registration successful!\n";
        } else {
            echo "❌ Device registration failed: " . ($data['message'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "❌ Upload request failed (HTTP $httpCode)\n";
    }
}

// Cleanup
unlink('/tmp/simple_cookies.txt');

echo "\n✅ Simple API Test Completed!\n";
echo "============================\n";
?>

